#!/bin/bash

echo "=========================================="
echo "Ticket System - MySQL Kurulum Scripti"
echo "=========================================="
echo ""

# .env dosyası kontrolü
if [ ! -f .env ]; then
    echo "📝 .env dosyası oluşturuluyor..."
    cat > .env << EOF
APP_NAME="Ticket System"
APP_ENV=local
APP_KEY=
APP_DEBUG=true
APP_URL=http://localhost

LOG_CHANNEL=stack
LOG_LEVEL=debug

DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=ticket_system
DB_USERNAME=root
DB_PASSWORD=

BROADCAST_DRIVER=log
CACHE_DRIVER=file
FILESYSTEM_DISK=local
QUEUE_CONNECTION=sync
SESSION_DRIVER=file
SESSION_LIFETIME=120

MAIL_MAILER=smtp
MAIL_HOST=mailpit
MAIL_PORT=1025
MAIL_USERNAME=null
MAIL_PASSWORD=null
MAIL_ENCRYPTION=null
MAIL_FROM_ADDRESS="hello@example.com"
MAIL_FROM_NAME="Ticket System"

VITE_APP_NAME="Ticket System"
EOF
    echo "✅ .env dosyası oluşturuldu!"
    echo ""
    echo "⚠️  LÜTFEN .env dosyasını düzenleyin ve MySQL bilgilerinizi girin:"
    echo "   - DB_DATABASE=ticket_system"
    echo "   - DB_USERNAME=root (veya MySQL kullanıcı adınız)"
    echo "   - DB_PASSWORD= (MySQL şifreniz, yoksa boş bırakın)"
    echo ""
    read -p "MySQL ayarlarını yaptınız mı? (y/n) " -n 1 -r
    echo
    if [[ ! $REPLY =~ ^[Yy]$ ]]; then
        echo "Lütfen .env dosyasını düzenleyip tekrar çalıştırın."
        exit 1
    fi
else
    echo "✅ .env dosyası mevcut"
fi

echo ""
echo "📦 Composer bağımlılıkları yükleniyor..."
composer install

echo ""
echo "🔑 Uygulama anahtarı oluşturuluyor..."
php artisan key:generate

echo ""
echo "🗄️  Veritabanı migration'ları çalıştırılıyor..."
echo "⚠️  MySQL veritabanının oluşturulduğundan emin olun!"
read -p "Devam edilsin mi? (y/n) " -n 1 -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
    php artisan migrate
else
    echo "Migration'lar atlandı. Manuel olarak çalıştırabilirsiniz: php artisan migrate"
fi

echo ""
read -p "Varsayılan kullanıcıları oluşturalım mı? (admin@example.com / password) (y/n) " -n 1 -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
    php artisan db:seed
    echo "✅ Varsayılan kullanıcılar oluşturuldu!"
fi

echo ""
echo "🔗 Storage link oluşturuluyor..."
php artisan storage:link

echo ""
echo "📦 NPM bağımlılıkları yükleniyor..."
npm install

echo ""
echo "=========================================="
echo "✅ Kurulum tamamlandı!"
echo "=========================================="
echo ""
echo "Sunucuyu başlatmak için:"
echo "  Terminal 1: php artisan serve"
echo "  Terminal 2: npm run dev"
echo ""
echo "Tarayıcıda: http://localhost:8000"
echo ""

